' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports System.Drawing.Imaging

Partial Class Controls_AddText
  Inherits System.Web.UI.UserControl

  Public Delegate Sub ImageFinalizedEventHandler(ByVal sender As System.Object, _
      ByVal e As FileHandlingEventArgs)
  Public Event ImageFinalized As ImageFinalizedEventHandler

  Private Sub InitializeControl()
    ' Dodaj list kolorw do listy rozwijanej lstKnownColors.
    lstKnownColors.DataSource = Toolkit.Imaging.GetColors(False)
    lstKnownColors.DataTextField = "Name"
    lstKnownColors.DataValueField = "Name"
    lstKnownColors.DataBind()
    ' Wstpnie wybierz kolor o wysokim kontracie.
        If lstKnownColors.Items.FindByText("Red") IsNot Nothing Then
            lstKnownColors.Items.FindByText("Red").Selected = True
        End If

    ' Dodaj list czcionek do listy rozwijanej lstFontNames.
    lstFontNames.DataSource = Toolkit.Imaging.GetFontFamilies()
    lstFontNames.DataTextField = "Name"
    lstFontNames.DataValueField = "Name"
    lstFontNames.DataBind()

    ' Aktualizuj kontrolk Image, eby wywietlaa obrazek przechowywany w FileName.
    UpdateImageControl(FileName)
  End Sub

  Protected Sub ImageButton1_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles ImageButton1.Click
    ' Pobierz wsprzdne X i Y z argumentw zdarzenia e.
    X = e.X
    Y = e.Y
    ' Dodaj tekst do obrazka
    AddText()
    plcAddText.Visible = True

    ' Wywietl kontrolki do zmiany tekstu i jego waciwoci.
    cellControls.Visible = True
  End Sub

  Protected Sub btnAddText_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddText.Click
    AddText()
  End Sub

  Private Sub AddText()
    If txtTextToAdd.Text.Length > 0 AndAlso lstFontNames.SelectedIndex > 0 Then
      Dim aFont As Font = New Font(lstFontNames.SelectedValue, _
             Convert.ToSingle(lstFontSizes.SelectedValue), _
             CType(FontStyle.Parse(GetType(FontStyle), _
             lstFontStyles.SelectedValue), FontStyle))

      Dim myColor As Color = Color.FromName(lstKnownColors.SelectedValue)
      Dim textLocation As Point = New Point(X, Y)

      Toolkit.Imaging.AddTextToImage(Server.MapPath(FileName), _
             Server.MapPath(TempFileName), aFont, myColor, _
             textLocation, txtTextToAdd.Text)

      UpdateImageControl(TempFileName)
      btnFinish.Visible = True
    End If
  End Sub

  Private Sub UpdateImageControl(ByVal theFileName As String)
    ImageButton1.ImageUrl = String.Format("{0}?TimeStamp={1}", theFileName, System.DateTime.Now.Millisecond.ToString())
  End Sub

  Protected Sub btnUndo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUndo.Click
    UpdateImageControl(FileName)
  End Sub

  Protected Sub lstFontName_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstFontNames.SelectedIndexChanged
    ' Wypenij list opcjami stylu w oparciu o style wspierane przez wybran czcionk.
    If lstFontNames.SelectedIndex > 0 Then
      lstFontStyles.Items.Clear()
      lstFontStyles.Visible = True
      Dim styles As FontStyle() = New FontStyle(3) {FontStyle.Regular, FontStyle.Bold, FontStyle.Italic, FontStyle.Bold Or FontStyle.Italic}
      Dim family As FontFamily = New FontFamily(lstFontNames.SelectedValue)
      For Each style As FontStyle In styles
        If family.IsStyleAvailable(style) Then
          lstFontStyles.Items.Add(style.ToString())
        End If
      Next
      rowSize.Visible = True
      rowStyle.Visible = True
      rowColor.Visible = True

      btnAddText.Visible = True
    End If
  End Sub

#Region "Waciwoci i metody wsplne dla wszystkich kontrolek uytkownika"

  Public Property FileName() As String
    Get
      If ViewState("FileName") IsNot Nothing Then
        Return ViewState("FileName").ToString()
      Else
        Return String.Empty
      End If
    End Get
    Set(ByVal value As String)
      If ViewState("FileName") Is Nothing Then
        ViewState("FileName") = value
        InitializeControl()
      Else
        ViewState("FileName") = value
      End If
    End Set
  End Property

  Private ReadOnly Property TempFileName() As String
    Get
      If ViewState("TempFileName") Is Nothing Then
        ViewState("TempFileName") = AppConfiguration.TempImagesFolder & "/" & Guid.NewGuid.ToString() & ".jpg"
      End If
      Return ViewState("TempFileName").ToString()
    End Get
  End Property

  Public Property FinishButtonText() As String
    Get
      Return btnFinish.Text
    End Get
    Set(ByVal value As String)
      btnFinish.Text = value
    End Set
  End Property

  Protected Sub btnFinish_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinish.Click
    FileName = TempFileName
    UpdateImageControl(FileName)
    RaiseEvent ImageFinalized(Me, New FileHandlingEventArgs(FileName))
  End Sub

#End Region

#Region "Prywatne waciwoci"

  Private Property X() As Integer
    Get
      If ViewState("X") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("X"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("X") = value
    End Set
  End Property

  Private Property Y() As Integer
    Get
      If ViewState("Y") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("Y"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      ViewState("Y") = value
    End Set
  End Property

#End Region

End Class
